import jwt from "jsonwebtoken"
import { createError } from "./error.js"


export const verifyToken = (req,res,next)=>{
    const token = req.cookies.access_token
    //console.log(req.cookies)
    if(!token){
     return next(createError(401, "You are not authenticated!"));
    }
    jwt.verify(token,process.env.JWT,(err,user)=>{
        if(err){
            return next(createError(403, "Token is not valid!"));
        }
        //console.log(jwt.verify)
        req.user = user;
        next()
    })

}
export const verifyUser = (req,res,next)=>{
    verifyToken(req,res,next,()=>{
        if(req.user.id === req.params.id || req.user.isAdmin){
            next();
        }else{
            return next(createError(401,"You are not authenticated"))
        }
    })
}
export const verifyAdmin = (req,res,next)=>{
    verifyToken(req,res,next,()=>{
        if(req.user.isAdmin){
            next();
        }else{
            return next(createError(401,"You are not authenticated"));
        }
    })
}